const require_chunk = require('./chunk-CUT6urMc.cjs');
let __vue_language_core = require("@vue/language-core");
__vue_language_core = require_chunk.__toESM(__vue_language_core);
let muggle_string = require("muggle-string");
muggle_string = require_chunk.__toESM(muggle_string);

//#region src/volar/entries/sfc-route-blocks.ts
const plugin = () => {
	const routeBlockIdPrefix = "route_";
	const routeBlockIdRe = /* @__PURE__ */ new RegExp(`^${routeBlockIdPrefix}(\\d+)$`);
	return {
		version: 2.1,
		getEmbeddedCodes(_fileName, sfc) {
			const embeddedCodes = [];
			for (let i = 0; i < sfc.customBlocks.length; i++) {
				const block = sfc.customBlocks[i];
				if (block.type === "route") {
					const lang = block.lang === "txt" ? "json" : block.lang;
					embeddedCodes.push({
						id: `${routeBlockIdPrefix}${i}`,
						lang
					});
				}
			}
			return embeddedCodes;
		},
		resolveEmbeddedCode(_fileName, sfc, embeddedCode) {
			const match = embeddedCode.id.match(routeBlockIdRe);
			if (match) {
				const i = parseInt(match[1]);
				const block = sfc.customBlocks[i];
				if (!block) return;
				embeddedCode.content.push([
					block.content,
					block.name,
					0,
					__vue_language_core.allCodeFeatures
				]);
				if (embeddedCode.lang === "json") {
					const contentStr = (0, muggle_string.toString)(embeddedCode.content);
					if (contentStr.trim().startsWith("{") && !contentStr.includes("$schema")) (0, muggle_string.replace)(embeddedCode.content, "{", "{\n  \"$schema\": \"https://raw.githubusercontent.com/posva/unplugin-vue-router/main/route.schema.json\",");
				}
			}
		}
	};
};
var sfc_route_blocks_default = plugin;

//#endregion
module.exports = sfc_route_blocks_default;