import { createViewportManager, STATE_KEY } from "./manager.js";
import { detectBreakpoint, parseCookie } from "./utils.js";
import { useViewportOptions } from "./composables.js";
import { defineNuxtPlugin, useState } from "#imports";
export default defineNuxtPlugin(async (nuxtApp) => {
  const viewportOptions = useViewportOptions();
  const state = useState(STATE_KEY);
  const manager = createViewportManager(viewportOptions, state);
  let cookie = "";
  let userAgent = "";
  const headers = nuxtApp?.ssrContext?.event?.req?.headers;
  if (headers != null) {
    cookie = headers.cookie;
    userAgent = headers["user-agent"];
  }
  if (typeof cookie !== "string") {
    cookie = "";
  }
  state.value = await detectBreakpoint(viewportOptions.value, {
    cookie: viewportOptions.value.cookie?.name ? parseCookie(cookie)[viewportOptions.value.cookie.name] : void 0,
    headers
  });
  return nuxtApp.provide("viewport", manager);
});
