import cookie from "cookiejs";
import { computed, toRef, toValue } from "vue-demi";
export const STATE_KEY = "viewportState";
export function createViewportManager(options, state) {
  options = toRef(options);
  const breakpoint = computed({
    get() {
      return state.value || options.value.fallbackBreakpoint;
    },
    set(newBreakpoint) {
      state.value = newBreakpoint;
      if (typeof window !== "undefined" && options.value.cookie.name) {
        cookie.set(options.value.cookie.name, state.value, options.value.cookie);
      }
    }
  });
  const queries = computed(() => {
    const delta = 0.1;
    const breakpoints = options.value.breakpoints || {};
    const breakpointsKeys = Object.keys(breakpoints).sort((a, b) => breakpoints[a] - breakpoints[b]);
    const output = {};
    let i = breakpointsKeys.length;
    while (i--) {
      const currentKey = breakpointsKeys[i];
      const size = breakpoints[currentKey];
      const nextSize = breakpoints[breakpointsKeys[i + 1]];
      const prevSize = breakpoints[breakpointsKeys[i - 1]];
      let mediaQuery = "";
      if (options.value.feature === "minWidth") {
        if (i > 0) {
          mediaQuery = `(min-width: ${size}px)`;
        } else {
          mediaQuery = "(min-width: 1px)";
        }
        if (nextSize) {
          mediaQuery += ` and (max-width: ${nextSize - delta}px)`;
        }
      } else {
        mediaQuery = `(max-width: ${size}px)`;
        if (prevSize) {
          mediaQuery = `(min-width: ${prevSize + delta}px) and ${mediaQuery}`;
        }
      }
      output[currentKey] = {
        mediaQuery,
        size
      };
    }
    return output;
  });
  const queriesKeys = computed(() => Object.keys(queries.value));
  return {
    breakpoint,
    breakpointValue,
    isGreaterThan,
    isGreaterOrEquals,
    isLessThan,
    isLessOrEquals,
    match,
    matches,
    queries
  };
  function breakpointValue(searchBreakpoint) {
    const breakpoints = toValue(options).breakpoints || {};
    return breakpoints[searchBreakpoint];
  }
  function isGreaterThan(searchBreakpoint) {
    const currentIndex = queriesKeys.value.indexOf(breakpoint.value);
    const breakpointIndex = queriesKeys.value.indexOf(searchBreakpoint);
    if (breakpointIndex === -1) {
      return false;
    }
    return breakpointIndex > currentIndex;
  }
  function isGreaterOrEquals(searchBreakpoint) {
    return isGreaterThan(searchBreakpoint) || match(searchBreakpoint);
  }
  function isLessThan(searchBreakpoint) {
    const currentIndex = queriesKeys.value.indexOf(breakpoint.value);
    const breakpointIndex = queriesKeys.value.indexOf(searchBreakpoint);
    if (breakpointIndex === -1) {
      return false;
    }
    return breakpointIndex < currentIndex;
  }
  function isLessOrEquals(searchBreakpoint) {
    return isLessThan(searchBreakpoint) || match(searchBreakpoint);
  }
  function match(breakpointToMatch) {
    return breakpoint.value === breakpointToMatch;
  }
  function matches(...breakpointsToMatch) {
    return breakpointsToMatch.includes(breakpoint.value);
  }
}
