import { computed } from "vue-demi";
import { extendOptions } from "./utils.js";
import { useNuxtApp, useRoute } from "#imports";
import globalOptions from "#viewport-options";
export function useViewport() {
  return useNuxtApp().$viewport;
}
export function useViewportOptions() {
  const route = useRoute();
  return computed(() => extendOptions(route.meta.viewport, globalOptions));
}
