import { fileURLToPath } from 'url';
import { defineNuxtModule, createResolver, addTemplate, addPlugin, addImports } from '@nuxt/kit';
import { extendOptions } from '../dist/runtime/utils.js';

const name = "nuxt-viewport";
const version = "2.3.1";

const module = defineNuxtModule({
  meta: {
    configKey: "viewport",
    compatibility: {
      bridge: true
    },
    name,
    version
  },
  setup(options, nuxt) {
    options = extendOptions(options);
    const { resolve } = createResolver(import.meta.url);
    const runtimeDir = fileURLToPath(new URL("./runtime", import.meta.url));
    nuxt.options.build.transpile.push(runtimeDir);
    nuxt.options.alias["#viewport-options"] = addTemplate({
      filename: "viewport-options.mjs",
      getContents() {
        return `export default ${JSON.stringify(options)}`;
      }
    }).dst;
    addPlugin(resolve(runtimeDir, "plugin.client"));
    addPlugin(resolve(runtimeDir, "plugin.server"));
    addImports({
      as: "useViewport",
      from: resolve(runtimeDir, "composables"),
      name: "useViewport"
    });
  }
});

export { module as default };
