import { _ as _sfc_main$1 } from "./Toast-BD7HuZap.js";
import { _ as _sfc_main$2 } from "./ErrorState-qff2oEvB.js";
import { t as toPersianDigits } from "./toPersianDigits-DB2ZciTc.js";
import { ref, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderList, ssrRenderAttr, ssrInterpolate, ssrIncludeBooleanAttr, ssrRenderClass } from "vue/server-renderer";
import { IconTrash, IconShoppingCart, IconPlus, IconMinus, IconHeartOff } from "@tabler/icons-vue";
import { _ as _export_sfc, c as useState, b as useRuntimeConfig } from "../server.mjs";
import { u as useCartStore } from "./cart-BfofACZK.js";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ofetch/dist/node.mjs";
import "#internal/nuxt/paths";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/hookable/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/unctx/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/h3/dist/index.mjs";
import "pinia";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/radix3/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ufo/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/klona/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/cookie-es/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/destr/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ohash/dist/index.mjs";
import "cookiejs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/@unhead/vue/dist/index.mjs";
import "click-outside-vue3";
const _sfc_main = {
  __name: "wishlist",
  __ssrInlineRender: true,
  setup(__props) {
    const pageTitle = useState("pageTitle");
    pageTitle.value = "لیست‌های من";
    const config = useRuntimeConfig();
    const cartStore = useCartStore();
    const products = ref([]);
    const whishListCount = ref(0);
    const loading = ref(true);
    const error = ref(false);
    const deletingId = ref(null);
    const toast = ref();
    const fetchProducts = async () => {
      try {
        loading.value = true;
        error.value = false;
        const response = await $fetch(`${config.public.apiBase}/wishlist`, {
          headers: {
            Authorization: `Bearer ${localStorage.getItem("shop_token")}`
          }
        });
        if (response?.status) {
          products.value = response.products || [];
          whishListCount.value = response.count || 0;
          console.log(response);
        }
      } catch (err) {
        console.error("Error fetching wishlist:", err);
        error.value = true;
      } finally {
        loading.value = false;
      }
    };
    const isInCart = (product) => {
      return cartStore.getItemQuantity(product.id, product.defualt_variation.id) > 0;
    };
    const isOutOfStock = (product) => {
      return !product.defualt_variation.quantity || product.defualt_variation.quantity === 0;
    };
    const getCartQuantity = (product) => {
      return cartStore.getItemQuantity(product.id, product.defualt_variation.id);
    };
    const isMaxQuantity = (product) => {
      return getCartQuantity(product) >= product.defualt_variation.quantity;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Toast = _sfc_main$1;
      const _component_ErrorState = _sfc_main$2;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Toast, {
        ref_key: "toast",
        ref: toast
      }, null, _parent));
      if (unref(loading)) {
        _push(`<div class="px-3 sm:px-4 py-4 space-y-3" data-v-91e75145><div class="animate-pulse space-y-3" data-v-91e75145><!--[-->`);
        ssrRenderList(3, (i) => {
          _push(`<div class="h-38.5 bg-gray-200 dark:bg-gray-800 rounded-xl" data-v-91e75145></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else if (unref(error)) {
        _push(`<div class="py-10" data-v-91e75145>`);
        _push(ssrRenderComponent(_component_ErrorState, { onRetry: fetchProducts }, null, _parent));
        _push(`</div>`);
      } else if (unref(whishListCount) > 0) {
        _push(`<div class="space-y-4 p-4 pb-24" data-v-91e75145><!--[-->`);
        ssrRenderList(unref(products), (product) => {
          _push(`<div class="bg-white dark:bg-gray-800 rounded-2xl overflow-hidden border border-gray-200 dark:border-gray-700 shadow-sm" data-v-91e75145><div class="flex gap-4 p-4" data-v-91e75145><div class="relative shrink-0" data-v-91e75145><div class="w-24 h-24 rounded-xl overflow-hidden bg-gray-100 dark:bg-gray-700 group cursor-pointer" data-v-91e75145><img${ssrRenderAttr("src", `${unref(config).public.mediaBase}/${product.primary_image}`)}${ssrRenderAttr("alt", product.name)} class="w-full h-full object-cover" data-v-91e75145></div>`);
          if (product.defualt_variation.discount_percent) {
            _push(`<div class="absolute -top-2 -right-2 bg-linear-to-br from-red-500 to-rose-600 text-white text-xs font-bold px-2.5 py-1 rounded-lg shadow-lg" data-v-91e75145>${ssrInterpolate(product.defualt_variation.discount_percent)}% </div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div><div class="flex-1 min-w-0 flex flex-col" data-v-91e75145><div class="flex items-start justify-between gap-2 mb-2" data-v-91e75145><div class="flex-1 text-right" data-v-91e75145><h3 class="text-sm font-bold text-gray-900 dark:text-white line-clamp-2" data-v-91e75145>${ssrInterpolate(product.name)}</h3></div><button class="shrink-0 p-2 rounded-xl text-gray-400 t"${ssrIncludeBooleanAttr(unref(deletingId) === product.id) ? " disabled" : ""} data-v-91e75145>`);
          _push(ssrRenderComponent(unref(IconTrash), {
            size: 20,
            "stroke-width": 1.5,
            class: { "animate-pulse": unref(deletingId) === product.id }
          }, null, _parent));
          _push(`</button></div><div class="mb-3" data-v-91e75145>`);
          if (product.defualt_variation.sale_price) {
            _push(`<div class="flex items-center gap-2 flex-wrap" data-v-91e75145><div class="flex items-baseline gap-1" data-v-91e75145><span class="text-lg font-bold text-gray-900 dark:text-white" data-v-91e75145>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(product.defualt_variation.sale_price))}</span><span class="text-xs text-gray-500 dark:text-gray-400" data-v-91e75145>تومان</span></div><span class="text-sm text-gray-400 dark:text-gray-500 line-through" data-v-91e75145>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(product.defualt_variation.price))}</span></div>`);
          } else {
            _push(`<div class="flex items-baseline gap-1" data-v-91e75145><span class="text-lg font-bold text-gray-900 dark:text-white" data-v-91e75145>${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(product.defualt_variation.price))}</span><span class="text-xs text-gray-500 dark:text-gray-400" data-v-91e75145>تومان</span></div>`);
          }
          _push(`</div>`);
          if (isOutOfStock(product)) {
            _push(`<div class="mb-3" data-v-91e75145><span class="inline-flex items-center gap-1.5 text-xs font-medium text-red-600 dark:text-red-400 bg-red-50 dark:bg-red-900/20 px-2.5 py-1 rounded-lg" data-v-91e75145><span class="w-1.5 h-1.5 rounded-full bg-red-600 dark:bg-red-400" data-v-91e75145></span> ناموجود </span></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div class="mt-auto" data-v-91e75145>`);
          if (!isInCart(product)) {
            _push(`<button${ssrIncludeBooleanAttr(isOutOfStock(product)) ? " disabled" : ""} class="w-full flex items-center justify-center gap-2 bg-primary disabled:bg-gray-300 dark:disabled:bg-gray-700 text-white font-medium text-sm py-2 px-4 rounded-xl" data-v-91e75145>`);
            _push(ssrRenderComponent(unref(IconShoppingCart), {
              size: 18,
              "stroke-width": 2
            }, null, _parent));
            _push(`<span data-v-91e75145>${ssrInterpolate(isOutOfStock(product) ? "ناموجود" : "افزودن به سبد")}</span></button>`);
          } else {
            _push(`<div class="flex items-center justify-between bg-gray-100 dark:bg-gray-700 rounded-xl overflow-hidden" data-v-91e75145><button${ssrIncludeBooleanAttr(isMaxQuantity(product)) ? " disabled" : ""} class="w-9 h-9 flex items-center justify-center text-primary dark:text-primary hover:bg-gray-200 dark:hover:bg-gray-600 transition-colors disabled:opacity-30 disabled:cursor-not-allowed active:scale-95" data-v-91e75145>`);
            _push(ssrRenderComponent(unref(IconPlus), { class: "w-5 h-5 stroke-[2.5]" }, null, _parent));
            _push(`</button><div class="w-10 flex items-center justify-center text-sm font-black text-gray-900 dark:text-white" data-v-91e75145>${ssrInterpolate(getCartQuantity(product))}</div><button class="${ssrRenderClass([
              getCartQuantity(product) === 1 ? "text-red-500 hover:bg-red-50 dark:hover:bg-red-900/20" : "text-primary hover:bg-gray-200 dark:hover:bg-gray-600",
              "w-9 h-9 flex items-center justify-center transition-colors active:scale-95"
            ])}" data-v-91e75145>`);
            if (getCartQuantity(product) === 1) {
              _push(ssrRenderComponent(unref(IconTrash), { class: "w-4 h-4" }, null, _parent));
            } else {
              _push(ssrRenderComponent(unref(IconMinus), { class: "w-5 h-5 stroke-[2.5]" }, null, _parent));
            }
            _push(`</button></div>`);
          }
          _push(`</div></div></div></div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<div class="flex flex-col items-center justify-center py-20 px-4" data-v-91e75145><div class="w-28 h-28 rounded-full bg-linear-to-br from-gray-100 to-gray-200 dark:from-gray-800 dark:to-gray-700 flex items-center justify-center mb-6 shadow-inner" data-v-91e75145>`);
        _push(ssrRenderComponent(unref(IconHeartOff), {
          size: 56,
          "stroke-width": 1.5,
          class: "text-gray-400 dark:text-gray-500"
        }, null, _parent));
        _push(`</div><h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3" data-v-91e75145> لیست علاقه‌مندی خالی است </h3><p class="text-sm text-gray-500 dark:text-gray-400 text-center max-w-xs mb-6" data-v-91e75145> محصولات مورد علاقه خود را به لیست اضافه کنید تا بعداً به راحتی به آن‌ها دسترسی داشته باشید </p><button class="inline-flex items-center gap-2 bg-primary text-white font-medium px-6 py-2 rounded-xl" data-v-91e75145><span data-v-91e75145>مشاهده محصولات</span></button></div>`);
      }
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/profile/wishlist.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const wishlist = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-91e75145"]]);
export {
  wishlist as default
};
//# sourceMappingURL=wishlist-C6asnpMU.js.map
