import { _ as _sfc_main$1 } from "./ErrorState-qff2oEvB.js";
import { _ as __nuxt_component_0 } from "./nuxt-link-DWMZ_O5T.js";
import { t as toPersianDigits } from "./toPersianDigits-DB2ZciTc.js";
import { ref, unref, mergeProps, withCtx, createVNode, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrInterpolate, ssrRenderAttr } from "vue/server-renderer";
import { IconPackageOff, IconFileDescription, IconPackage, IconCalendarTime, IconChevronLeft, IconShoppingCart, IconFileDownload } from "@tabler/icons-vue";
import { c as useState, b as useRuntimeConfig } from "../server.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ufo/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ofetch/dist/node.mjs";
import "#internal/nuxt/paths";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/hookable/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/unctx/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/h3/dist/index.mjs";
import "pinia";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/radix3/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/klona/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/cookie-es/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/destr/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ohash/dist/index.mjs";
import "cookiejs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/@unhead/vue/dist/index.mjs";
import "click-outside-vue3";
const _sfc_main = {
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    const pageTitle = useState("pageTitle");
    pageTitle.value = "سفارش‌های جاری";
    const config = useRuntimeConfig();
    const orders = ref([]);
    const loading = ref(false);
    const error = ref(false);
    const fetchOrders = async () => {
      try {
        loading.value = true;
        error.value = false;
        const response = await $fetch(`${config.public.apiBase}/order/inprogress`, {
          headers: {
            Authorization: `Bearer ${localStorage.getItem("shop_token")}`
          }
        });
        orders.value = response.order;
      } catch (err) {
        error.value = true;
      } finally {
        loading.value = false;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ErrorState = _sfc_main$1;
      const _component_NuxtLink = __nuxt_component_0;
      if (unref(loading)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "px-3 sm:px-4 py-4 space-y-3" }, _attrs))}><div class="animate-pulse space-y-3"><!--[-->`);
        ssrRenderList(3, (i) => {
          _push(`<div class="h-38.5 bg-gray-200 dark:bg-gray-800 rounded-xl"></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else if (unref(error)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex h-[calc(100vh-132px)] justify-center" }, _attrs))}>`);
        _push(ssrRenderComponent(_component_ErrorState, { onRetry: fetchOrders }, null, _parent));
        _push(`</div>`);
      } else if (unref(orders).length === 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex flex-col items-center justify-center px-4 py-16 text-center" }, _attrs))}><div class="w-20 h-20 mb-4 bg-gray-100 dark:bg-gray-800 rounded-full flex items-center justify-center">`);
        _push(ssrRenderComponent(unref(IconPackageOff), { class: "w-10 h-10 text-gray-400" }, null, _parent));
        _push(`</div><h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2"> سفارشی یافت نشد </h3><p class="text-sm text-gray-500 dark:text-gray-400 mb-6"> هنوز سفارش تحویل‌شده‌ای ندارید </p><button class="inline-flex items-center gap-2 bg-primary text-white font-medium px-6 py-2 rounded-xl"><span>مشاهده محصولات</span></button></div>`);
      } else {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "px-4 mt-4 space-y-3" }, _attrs))}><!--[-->`);
        ssrRenderList(unref(orders), (order) => {
          _push(`<article class="group bg-white dark:bg-gray-800 rounded-2xl shadow-sm transition-all duration-300 overflow-hidden border border-gray-100 dark:border-gray-700"><div class="px-4 pt-4 pb-3 border-b border-gray-100 dark:border-gray-700/50"><div class="flex items-start justify-between gap-3"><div class="flex-1 min-w-0"><div class="flex items-center gap-2 mb-2"><span class="inline-flex items-center gap-1.5 text-sm font-semibold text-gray-900 dark:text-white">`);
          _push(ssrRenderComponent(unref(IconFileDescription), { class: "w-4 h-4 text-gray-400" }, null, _parent));
          _push(` ${ssrInterpolate(order.id)}</span></div><div class="inline-flex items-center gap-1 text-xs font-medium px-3 py-1.5 rounded-full bg-blue-50 text-blue-700 dark:bg-blue-900/20 dark:text-blue-300">`);
          _push(ssrRenderComponent(unref(IconPackage), { class: "w-4 h-4" }, null, _parent));
          _push(`<span>در حال ارسال </span></div></div><div class="flex flex-col items-end gap-1"><span class="text-lg font-bold text-gray-900 dark:text-white whitespace-nowrap">${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(order.total))}</span><span class="text-xs text-gray-500 dark:text-gray-400"> تومان </span></div></div></div><div class="px-4 py-3"><div class="flex items-center gap-2 mb-3 text-sm text-gray-600 dark:text-gray-400">`);
          _push(ssrRenderComponent(unref(IconCalendarTime), { class: "w-4 h-4" }, null, _parent));
          _push(`<span>ثبت شده در: ${ssrInterpolate(order.transactionTimeSuccess)}</span></div><div class="flex items-center gap-2"><div class="flex -space-x-2"><!--[-->`);
          ssrRenderList(order.images.slice(0, 4), (img, index) => {
            _push(`<img${ssrRenderAttr("src", `${unref(config).public.mediaBase}/${img}`)}${ssrRenderAttr("alt", `محصول ${index + 1}`)} class="w-12 h-12 rounded-xl object-cover border-2 border-white dark:border-gray-800 shadow-sm cursor-pointer" loading="lazy">`);
          });
          _push(`<!--]--></div>`);
          _push(ssrRenderComponent(_component_NuxtLink, {
            class: "mr-auto inline-flex items-center gap-1.5 text-sm font-medium text-primary",
            to: `/profile/orders/in-progress/${order.id}`
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<span${_scopeId}>جزئیات</span>`);
                _push2(ssrRenderComponent(unref(IconChevronLeft), { class: "w-4 h-4" }, null, _parent2, _scopeId));
              } else {
                return [
                  createVNode("span", null, "جزئیات"),
                  createVNode(unref(IconChevronLeft), { class: "w-4 h-4" })
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div></div><div class="px-4 pb-4 pt-2 flex gap-2"><button class="flex-1 inline-flex items-center justify-center gap-2 px-4 py-2.5 bg-primary text-white text-sm font-medium rounded-xl shadow-sm">`);
          _push(ssrRenderComponent(unref(IconShoppingCart), { class: "w-4 h-4" }, null, _parent));
          _push(`<span>سفارش مجدد</span></button><button class="inline-flex items-center justify-center gap-2 px-4 py-2.5 bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-200 text-sm font-medium rounded-xl">`);
          _push(ssrRenderComponent(unref(IconFileDownload), { class: "w-4 h-4" }, null, _parent));
          _push(`<span>فاکتور</span></button></div></article>`);
        });
        _push(`<!--]--></div>`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/profile/orders/in-progress/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=index-BgtosCft.js.map
