import { _ as _sfc_main$2 } from "./Toast-BD7HuZap.js";
import { _ as _sfc_main$3 } from "./ErrorState-qff2oEvB.js";
import { computed, ref, watch, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderClass, ssrRenderList, ssrIncludeBooleanAttr, ssrLooseContain } from "vue/server-renderer";
import { IconChevronRight, IconExclamationCircleFilled, IconChevronDown, IconMapPinOff, IconEdit, IconTrash, IconMapPin, IconHome, IconMailbox, IconPhone, IconPlus } from "@tabler/icons-vue";
import { a as useRouter, b as useRuntimeConfig, c as useState, d as useRoute } from "../server.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ofetch/dist/node.mjs";
import "#internal/nuxt/paths";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/hookable/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/unctx/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/h3/dist/index.mjs";
import "pinia";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/radix3/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ufo/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/klona/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/cookie-es/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/destr/dist/index.mjs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/ohash/dist/index.mjs";
import "cookiejs";
import "C:/Users/Lenevo/Desktop/iranshop-nuxt/node_modules/@unhead/vue/dist/index.mjs";
import "click-outside-vue3";
const _sfc_main$1 = {
  __name: "AddressModal",
  __ssrInlineRender: true,
  props: {
    isOpen: {
      type: Boolean,
      required: true
    },
    addressToEdit: {
      type: Object,
      default: null
    }
  },
  setup(__props) {
    useRouter();
    const config = useRuntimeConfig();
    const props = __props;
    const isEditMode = computed(() => !!props.addressToEdit);
    const submitting = ref(false);
    const provinces = ref([]);
    const cities = ref([]);
    const loadingCities = ref(false);
    const isProvinceOpen = ref(false);
    const isCityOpen = ref(false);
    const selectedProvince = ref(null);
    const selectedCity = ref(null);
    const toast = ref();
    ref(null);
    ref(null);
    const isSelfReceiver = ref(false);
    const form = ref({
      title: "",
      cellphone: "",
      address: "",
      postal_code: "",
      province_id: null,
      city_id: null
    });
    const errors = ref({
      title: "",
      cellphone: "",
      address: "",
      postal_code: "",
      province_id: "",
      city_id: ""
    });
    const resetForm = () => {
      form.value = {
        title: "",
        cellphone: "",
        address: "",
        postal_code: "",
        province_id: null,
        city_id: null
      };
      selectedProvince.value = null;
      selectedCity.value = null;
      cities.value = [];
      errors.value = {
        title: "",
        cellphone: "",
        address: "",
        postal_code: "",
        province_id: "",
        city_id: ""
      };
    };
    const fetchProvinces = async () => {
      try {
        const response = await $fetch(`${config.public.apiBase}/province`, {
          headers: {
            Authorization: `Bearer ${localStorage.getItem("shop_token")}`
          }
        });
        if (response.status === "success") {
          provinces.value = response.data;
        }
      } catch (err) {
        console.error("Error fetching provinces:", err);
      }
    };
    const fetchCities = async (provinceId) => {
      if (!provinceId) return;
      try {
        loadingCities.value = true;
        cities.value = [];
        const response = await $fetch(
          `${config.public.apiBase}/provinceCities/${provinceId}`,
          {
            headers: {
              Authorization: `Bearer ${localStorage.getItem("shop_token")}`
            }
          }
        );
        if (response.status === "success") {
          cities.value = response.data;
        }
      } catch (err) {
        console.error("Error fetching cities:", err);
      } finally {
        loadingCities.value = false;
      }
    };
    const populateForm = async (address) => {
      if (!address) {
        resetForm();
        return;
      }
      isSelfReceiver.value = !address.cellphone;
      form.value = {
        title: address.title || "",
        cellphone: address.cellphone || "",
        address: address.address || "",
        postal_code: address.postal_code || "",
        province_id: address.province_id,
        city_id: address.city_id
      };
      if (provinces.value.length === 0) {
        await fetchProvinces();
      }
      const province = provinces.value.find((p) => p.id === address.province_id);
      if (province) {
        selectedProvince.value = province;
        await fetchCities(province.id);
        const city = cities.value.find((c) => c.id === address.city_id);
        if (city) {
          selectedCity.value = city;
        }
      }
    };
    watch(
      () => props.isOpen,
      (isOpen) => {
        if (isOpen && props.addressToEdit) {
          populateForm(props.addressToEdit);
        } else if (!isOpen) {
          resetForm();
        }
      }
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Toast = _sfc_main$2;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Toast, {
        ref_key: "toast",
        ref: toast
      }, null, _parent));
      if (__props.isOpen) {
        _push(`<div class="fixed inset-0 z-50 bg-white dark:bg-gray-900"><div class="sticky top-0 z-10 border-b border-gray-200 dark:border-gray-700 px-3 sm:px-4 py-3 sm:py-4 flex items-center bg-white dark:bg-gray-900"><button class="p-2 -m-2 rounded-lg transition-colors">`);
        _push(ssrRenderComponent(unref(IconChevronRight), { class: "w-6 h-6 text-gray-700 dark:text-gray-300" }, null, _parent));
        _push(`</button><h1 class="text-md md:text-lg font-black text-gray-900 dark:text-white mr-2">${ssrInterpolate(unref(isEditMode) ? "ویرایش آدرس" : "افزودن آدرس")}</h1></div><div class="bg-white dark:bg-gray-800 p-4 sm:p-6 space-y-5 overflow-y-auto h-[calc(100vh-130px)]"><div class="space-y-2"><label class="text-sm font-bold text-gray-900 dark:text-white block"> عنوان آدرس <span class="text-red-500">*</span></label><input${ssrRenderAttr("value", unref(form).title)} type="text" placeholder="مثال: خانه، محل کار" class="w-full px-4 py-3 rounded-xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-900 text-gray-900 dark:text-white placeholder-gray-400 focus:border-primary focus:outline-none text-sm sm:text-base transition-colors">`);
        if (unref(errors).title) {
          _push(`<p class="text-sm text-red-500 flex items-center gap-1">`);
          _push(ssrRenderComponent(unref(IconExclamationCircleFilled), { class: "w-4 h-4" }, null, _parent));
          _push(` ${ssrInterpolate(unref(errors).title)}</p>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="space-y-2"><label class="text-sm font-bold text-gray-900 dark:text-white block"> استان <span class="text-red-500">*</span></label><div class="relative"><button type="button" class="${ssrRenderClass([{ "border-primary": unref(isProvinceOpen) }, "w-full flex items-center justify-between px-4 py-3 rounded-xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-900 text-gray-900 dark:text-white focus:border-primary focus:outline-none text-sm sm:text-base transition-colors"])}"><span class="${ssrRenderClass({ "text-gray-400": !unref(selectedProvince) })}">${ssrInterpolate(unref(selectedProvince)?.name || "انتخاب استان")}</span>`);
        _push(ssrRenderComponent(unref(IconChevronDown), {
          class: ["w-5 h-5 transition-transform", unref(isProvinceOpen) ? "rotate-180" : ""]
        }, null, _parent));
        _push(`</button>`);
        if (unref(isProvinceOpen)) {
          _push(`<div class="absolute left-0 right-0 mt-1 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-xl shadow-xl z-20 max-h-60 overflow-y-auto"><!--[-->`);
          ssrRenderList(unref(provinces), (province) => {
            _push(`<button type="button" class="${ssrRenderClass([
              unref(selectedProvince)?.id === province.id ? "bg-primary/5 dark:bg-primary/10 text-primary font-bold" : "text-gray-900 dark:text-white",
              "w-full text-right px-4 py-3 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors text-sm sm:text-base"
            ])}">${ssrInterpolate(province.name)}</button>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        if (unref(errors).province_id) {
          _push(`<p class="text-sm text-red-500 flex items-center gap-1">`);
          _push(ssrRenderComponent(unref(IconExclamationCircleFilled), { class: "w-4 h-4" }, null, _parent));
          _push(` ${ssrInterpolate(unref(errors).province_id)}</p>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="space-y-2"><label class="text-sm font-bold text-gray-900 dark:text-white block"> شهر <span class="text-red-500">*</span></label><div class="relative"><button type="button"${ssrIncludeBooleanAttr(!unref(selectedProvince) || unref(loadingCities)) ? " disabled" : ""} class="${ssrRenderClass([{ "border-primary": unref(isCityOpen) }, "w-full flex items-center justify-between px-4 py-3 rounded-xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-900 text-gray-900 dark:text-white focus:border-primary focus:outline-none text-sm sm:text-base disabled:opacity-50 disabled:cursor-not-allowed transition-colors"])}"><span class="${ssrRenderClass({ "text-gray-400": !unref(selectedCity) })}">${ssrInterpolate(unref(loadingCities) ? "در حال بارگذاری..." : unref(selectedCity)?.name || "انتخاب شهر")}</span>`);
        if (!unref(loadingCities)) {
          _push(ssrRenderComponent(unref(IconChevronDown), {
            class: ["w-5 h-5 transition-transform", unref(isCityOpen) ? "rotate-180" : ""]
          }, null, _parent));
        } else {
          _push(`<div class="w-5 h-5 border-2 border-primary border-t-transparent rounded-full animate-spin"></div>`);
        }
        _push(`</button>`);
        if (unref(isCityOpen) && unref(cities).length) {
          _push(`<div class="absolute left-0 right-0 mt-1 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-xl shadow-xl z-20 max-h-60 overflow-y-auto"><!--[-->`);
          ssrRenderList(unref(cities), (city) => {
            _push(`<button type="button" class="${ssrRenderClass([
              unref(selectedCity)?.id === city.id ? "bg-primary/5 dark:bg-primary/10 text-primary font-bold" : "text-gray-900 dark:text-white",
              "w-full text-right px-4 py-3 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors text-sm sm:text-base"
            ])}">${ssrInterpolate(city.name)}</button>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        if (unref(errors).city_id) {
          _push(`<p class="text-sm text-red-500 flex items-center gap-1">`);
          _push(ssrRenderComponent(unref(IconExclamationCircleFilled), { class: "w-4 h-4" }, null, _parent));
          _push(` ${ssrInterpolate(unref(errors).city_id)}</p>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="space-y-2"><label class="text-sm font-bold text-gray-900 dark:text-white block"> آدرس کامل <span class="text-red-500">*</span></label><textarea rows="4" placeholder="خیابان، کوچه، پلاک، واحد..." class="w-full px-4 py-3 rounded-xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-900 text-gray-900 dark:text-white placeholder-gray-400 focus:border-primary focus:outline-none resize-none text-sm sm:text-base transition-colors">${ssrInterpolate(unref(form).address)}</textarea>`);
        if (unref(errors).address) {
          _push(`<p class="text-sm text-red-500 flex items-center gap-1">`);
          _push(ssrRenderComponent(unref(IconExclamationCircleFilled), { class: "w-4 h-4" }, null, _parent));
          _push(` ${ssrInterpolate(unref(errors).address)}</p>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="space-y-2"><label class="text-sm font-bold text-gray-900 dark:text-white block"> کد پستی <span class="text-red-500">*</span></label><input${ssrRenderAttr("value", unref(form).postal_code)} type="text" dir="ltr" placeholder="1234567890" maxlength="10" class="w-full px-4 py-3 rounded-xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-900 text-gray-900 dark:text-white placeholder-gray-400 focus:border-primary focus:outline-none text-sm sm:text-base transition-colors">`);
        if (unref(errors).postal_code) {
          _push(`<p class="text-sm text-red-500 flex items-center gap-1">`);
          _push(ssrRenderComponent(unref(IconExclamationCircleFilled), { class: "w-4 h-4" }, null, _parent));
          _push(` ${ssrInterpolate(unref(errors).postal_code)}</p>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="flex items-center gap-2"><input${ssrIncludeBooleanAttr(Array.isArray(unref(isSelfReceiver)) ? ssrLooseContain(unref(isSelfReceiver), null) : unref(isSelfReceiver)) ? " checked" : ""} type="checkbox" id="self-receiver" class="w-4 h-4 accent-primary"><label for="self-receiver" class="text-sm font-medium text-gray-700 dark:text-gray-300 cursor-pointer select-none"> تحویل گیرنده خودم هستم </label></div>`);
        if (!unref(isSelfReceiver)) {
          _push(`<div class="space-y-2"><label class="text-sm font-bold text-gray-900 dark:text-white block"> شماره موبایل <span class="text-red-500">*</span></label><input${ssrRenderAttr("value", unref(form).cellphone)} type="tel" placeholder="09123456789" maxlength="11" class="w-full px-4 py-3 rounded-xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-900 text-gray-900 dark:text-white placeholder-gray-400 focus:border-primary focus:outline-none text-sm sm:text-base"></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="btns-container"><button${ssrIncludeBooleanAttr(unref(submitting)) ? " disabled" : ""} class="w-full btn-primary flex items-center justify-center gap-2 disabled:opacity-50 disabled:cursor-not-allowed">`);
        if (unref(submitting)) {
          _push(`<div class="w-5 h-5 border-2 border-white border-t-transparent rounded-full animate-spin"></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<span>${ssrInterpolate(unref(submitting) ? "در حال ثبت..." : "ثبت آدرس")}</span></button></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/AddressModal.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const __nuxt_component_2 = Object.assign(_sfc_main$1, { __name: "AddressModal" });
const _sfc_main = {
  __name: "addresses",
  __ssrInlineRender: true,
  setup(__props) {
    const pageTitle = useState("pageTitle");
    pageTitle.value = "آدرس‌های من";
    useRouter();
    const route = useRoute();
    const config = useRuntimeConfig();
    const loading = ref(true);
    const error = ref(false);
    const addresses = ref([]);
    const deleting = ref(false);
    const toast = ref(null);
    const addressToEdit = ref(null);
    const fetchAddresses = async () => {
      try {
        loading.value = true;
        error.value = false;
        const response = await $fetch(`${config.public.apiBase}/address`, {
          headers: {
            Authorization: `Bearer ${localStorage.getItem("shop_token")}`
          }
        });
        if (response.status === "success" && response.data) {
          addresses.value = response.data;
        }
      } catch (err) {
        console.error("Error fetching addresses:", err);
        error.value = true;
      } finally {
        loading.value = false;
      }
    };
    watch(
      () => route.query,
      () => {
        if (!route.query.mode) {
          addressToEdit.value = null;
          fetchAddresses();
        }
      }
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Toast = _sfc_main$2;
      const _component_ErrorState = _sfc_main$3;
      const _component_AddressModal = __nuxt_component_2;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Toast, {
        ref_key: "toast",
        ref: toast
      }, null, _parent));
      if (unref(loading)) {
        _push(`<div class="px-3 sm:px-4 py-4 space-y-3"><div class="animate-pulse space-y-3"><!--[-->`);
        ssrRenderList(3, (i) => {
          _push(`<div class="h-46 bg-gray-200 dark:bg-gray-800 rounded-xl"></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else if (unref(error)) {
        _push(`<div class="py-10">`);
        _push(ssrRenderComponent(_component_ErrorState, { onRetry: fetchAddresses }, null, _parent));
        _push(`</div>`);
      } else if (unref(addresses).length === 0) {
        _push(`<div class="h-[calc(100vh-132px)] flex items-center justify-center"><div class="px-3 py-12 text-center"><div class="w-16 h-16 mx-auto mb-4 bg-gray-100 dark:bg-gray-800 rounded-full flex items-center justify-center">`);
        _push(ssrRenderComponent(unref(IconMapPinOff), { class: "w-8 h-8 text-gray-400" }, null, _parent));
        _push(`</div><p class="text-gray-500 dark:text-gray-400 text-sm sm:text-base mb-4"> هنوز آدرسی ثبت نکرده‌اید. </p></div></div>`);
      } else if (unref(addresses).length) {
        _push(`<div class="px-3 py-4 space-y-3 h-full"><!--[-->`);
        ssrRenderList(unref(addresses), (address) => {
          _push(`<div class="${ssrRenderClass([
            address.is_default ? "border-2 border-primary shadow-primary/20 " : "border border-gray-100 dark:border-gray-700",
            "bg-white dark:bg-gray-800 rounded-xl sm:rounded-2xl p-3 cursor-pointer"
          ])}"><div class="flex items-center justify-between mb-3"><h3 class="text-base font-black text-gray-900 dark:text-white">${ssrInterpolate(address.title)}</h3><div class="flex items-center gap-2"><button class="p-2 text-primary bg-primary/10 rounded-lg transition-colors active:scale-95">`);
          _push(ssrRenderComponent(unref(IconEdit), { class: "w-5 h-5" }, null, _parent));
          _push(`</button><button${ssrIncludeBooleanAttr(unref(deleting)) ? " disabled" : ""} class="p-2 text-red-500 bg-red-50 dark:bg-red-900/20 rounded-lg transition-colors active:scale-95">`);
          _push(ssrRenderComponent(unref(IconTrash), { class: "w-5 h-5" }, null, _parent));
          _push(`</button></div></div><div class="space-y-2 text-sm sm:text-base"><div class="flex items-start gap-2">`);
          _push(ssrRenderComponent(unref(IconMapPin), { class: "w-4 h-4 sm:w-5 sm:h-5 text-gray-400 shrink-0 mt-0.5" }, null, _parent));
          _push(`<p class="text-sm text-gray-700 dark:text-gray-300 leading-relaxed">${ssrInterpolate(address.province)}، ${ssrInterpolate(address.city)}</p></div><div class="flex items-start gap-2">`);
          _push(ssrRenderComponent(unref(IconHome), { class: "w-4 h-4 sm:w-5 sm:h-5 text-gray-400 shrink-0 mt-0.5" }, null, _parent));
          _push(`<p class="text-sm text-gray-700 dark:text-gray-300 leading-relaxed">${ssrInterpolate(address.address)}</p></div><div class="flex items-center gap-2">`);
          _push(ssrRenderComponent(unref(IconMailbox), { class: "w-4 h-4 sm:w-5 sm:h-5 text-gray-400 shrink-0" }, null, _parent));
          _push(`<p class="text-sm text-gray-600 dark:text-gray-400"> کد پستی: ${ssrInterpolate(address.postal_code)}</p></div><div class="flex items-center gap-2">`);
          _push(ssrRenderComponent(unref(IconPhone), { class: "w-4 h-4 sm:w-5 sm:h-5 text-gray-400 shrink-0" }, null, _parent));
          _push(`<p class="text-sm text-gray-600 dark:text-gray-400 font-medium" dir="ltr">${ssrInterpolate(address.cellphone)}</p></div></div></div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_AddressModal, {
        "is-open": !!unref(route).query.mode,
        "address-to-edit": unref(addressToEdit)
      }, null, _parent));
      _push(`<button class="fixed bottom-18 left-4 z-10 flex items-center gap-2 pl-3.5 pr-2 py-3 bg-primary text-white rounded-lg font-bold text-sm active:scale-95 transition-all">`);
      _push(ssrRenderComponent(unref(IconPlus), { class: "w-5 h-5" }, null, _parent));
      _push(`<span class="hidden sm:inline">افزودن آدرس</span></button><!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/profile/addresses.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=addresses-C0Y136N_.js.map
