
import type { DefineComponent, SlotsType } from 'vue'
type IslandComponent<T> = DefineComponent<{}, {refresh: () => Promise<void>}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, SlotsType<{ fallback: { error: unknown } }>> & T

type HydrationStrategies = {
  hydrateOnVisible?: IntersectionObserverInit | true
  hydrateOnIdle?: number | true
  hydrateOnInteraction?: keyof HTMLElementEventMap | Array<keyof HTMLElementEventMap> | true
  hydrateOnMediaQuery?: string
  hydrateAfter?: number
  hydrateWhen?: boolean
  hydrateNever?: true
}
type LazyComponent<T> = DefineComponent<HydrationStrategies, {}, {}, {}, {}, {}, {}, { hydrated: () => void }> & T


export const AddressModal: typeof import("../../../../app/components/AddressModal.vue")['default']
export const CardSkeleton: typeof import("../../../../app/components/CardSkeleton.vue")['default']
export const ChangeReviewModal: typeof import("../../../../app/components/ChangeReviewModal.vue")['default']
export const CommentsSection: typeof import("../../../../app/components/CommentsSection.vue")['default']
export const ErrorState: typeof import("../../../../app/components/ErrorState.vue")['default']
export const Header: typeof import("../../../../app/components/Header.vue")['default']
export const AmazingSection: typeof import("../../../../app/components/Home/AmazingSection.vue")['default']
export const BannerSlider: typeof import("../../../../app/components/Home/BannerSlider.vue")['default']
export const NewestSection: typeof import("../../../../app/components/Home/NewestSection.vue")['default']
export const SearchBar: typeof import("../../../../app/components/Home/SearchBar.vue")['default']
export const Navigation: typeof import("../../../../app/components/Navigation.vue")['default']
export const ProductCard: typeof import("../../../../app/components/ProductCard.vue")['default']
export const ProductsListPage: typeof import("../../../../app/components/ProductsListPage.vue")['default']
export const SupportModal: typeof import("../../../../app/components/SupportModal.vue")['default']
export const Toast: typeof import("../../../../app/components/Toast.vue")['default']
export const NuxtWelcome: typeof import("../../../nuxt/dist/app/components/welcome.vue")['default']
export const NuxtLayout: typeof import("../../../nuxt/dist/app/components/nuxt-layout")['default']
export const NuxtErrorBoundary: typeof import("../../../nuxt/dist/app/components/nuxt-error-boundary.vue")['default']
export const ClientOnly: typeof import("../../../nuxt/dist/app/components/client-only")['default']
export const DevOnly: typeof import("../../../nuxt/dist/app/components/dev-only")['default']
export const ServerPlaceholder: typeof import("../../../nuxt/dist/app/components/server-placeholder")['default']
export const NuxtLink: typeof import("../../../nuxt/dist/app/components/nuxt-link")['default']
export const NuxtLoadingIndicator: typeof import("../../../nuxt/dist/app/components/nuxt-loading-indicator")['default']
export const NuxtTime: typeof import("../../../nuxt/dist/app/components/nuxt-time.vue")['default']
export const NuxtRouteAnnouncer: typeof import("../../../nuxt/dist/app/components/nuxt-route-announcer")['default']
export const NuxtImg: typeof import("../../../nuxt/dist/app/components/nuxt-stubs")['NuxtImg']
export const NuxtPicture: typeof import("../../../nuxt/dist/app/components/nuxt-stubs")['NuxtPicture']
export const ColorScheme: typeof import("../../../@nuxtjs/color-mode/dist/runtime/component.vue3.vue")['default']
export const NuxtPage: typeof import("../../../nuxt/dist/pages/runtime/page")['default']
export const NoScript: typeof import("../../../nuxt/dist/head/runtime/components")['NoScript']
export const Link: typeof import("../../../nuxt/dist/head/runtime/components")['Link']
export const Base: typeof import("../../../nuxt/dist/head/runtime/components")['Base']
export const Title: typeof import("../../../nuxt/dist/head/runtime/components")['Title']
export const Meta: typeof import("../../../nuxt/dist/head/runtime/components")['Meta']
export const Style: typeof import("../../../nuxt/dist/head/runtime/components")['Style']
export const Head: typeof import("../../../nuxt/dist/head/runtime/components")['Head']
export const Html: typeof import("../../../nuxt/dist/head/runtime/components")['Html']
export const Body: typeof import("../../../nuxt/dist/head/runtime/components")['Body']
export const NuxtIsland: typeof import("../../../nuxt/dist/app/components/nuxt-island")['default']
export const LazyAddressModal: LazyComponent<typeof import("../../../../app/components/AddressModal.vue")['default']>
export const LazyCardSkeleton: LazyComponent<typeof import("../../../../app/components/CardSkeleton.vue")['default']>
export const LazyChangeReviewModal: LazyComponent<typeof import("../../../../app/components/ChangeReviewModal.vue")['default']>
export const LazyCommentsSection: LazyComponent<typeof import("../../../../app/components/CommentsSection.vue")['default']>
export const LazyErrorState: LazyComponent<typeof import("../../../../app/components/ErrorState.vue")['default']>
export const LazyHeader: LazyComponent<typeof import("../../../../app/components/Header.vue")['default']>
export const LazyAmazingSection: LazyComponent<typeof import("../../../../app/components/Home/AmazingSection.vue")['default']>
export const LazyBannerSlider: LazyComponent<typeof import("../../../../app/components/Home/BannerSlider.vue")['default']>
export const LazyNewestSection: LazyComponent<typeof import("../../../../app/components/Home/NewestSection.vue")['default']>
export const LazySearchBar: LazyComponent<typeof import("../../../../app/components/Home/SearchBar.vue")['default']>
export const LazyNavigation: LazyComponent<typeof import("../../../../app/components/Navigation.vue")['default']>
export const LazyProductCard: LazyComponent<typeof import("../../../../app/components/ProductCard.vue")['default']>
export const LazyProductsListPage: LazyComponent<typeof import("../../../../app/components/ProductsListPage.vue")['default']>
export const LazySupportModal: LazyComponent<typeof import("../../../../app/components/SupportModal.vue")['default']>
export const LazyToast: LazyComponent<typeof import("../../../../app/components/Toast.vue")['default']>
export const LazyNuxtWelcome: LazyComponent<typeof import("../../../nuxt/dist/app/components/welcome.vue")['default']>
export const LazyNuxtLayout: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-layout")['default']>
export const LazyNuxtErrorBoundary: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-error-boundary.vue")['default']>
export const LazyClientOnly: LazyComponent<typeof import("../../../nuxt/dist/app/components/client-only")['default']>
export const LazyDevOnly: LazyComponent<typeof import("../../../nuxt/dist/app/components/dev-only")['default']>
export const LazyServerPlaceholder: LazyComponent<typeof import("../../../nuxt/dist/app/components/server-placeholder")['default']>
export const LazyNuxtLink: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-link")['default']>
export const LazyNuxtLoadingIndicator: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-loading-indicator")['default']>
export const LazyNuxtTime: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-time.vue")['default']>
export const LazyNuxtRouteAnnouncer: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-route-announcer")['default']>
export const LazyNuxtImg: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-stubs")['NuxtImg']>
export const LazyNuxtPicture: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-stubs")['NuxtPicture']>
export const LazyColorScheme: LazyComponent<typeof import("../../../@nuxtjs/color-mode/dist/runtime/component.vue3.vue")['default']>
export const LazyNuxtPage: LazyComponent<typeof import("../../../nuxt/dist/pages/runtime/page")['default']>
export const LazyNoScript: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components")['NoScript']>
export const LazyLink: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components")['Link']>
export const LazyBase: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components")['Base']>
export const LazyTitle: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components")['Title']>
export const LazyMeta: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components")['Meta']>
export const LazyStyle: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components")['Style']>
export const LazyHead: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components")['Head']>
export const LazyHtml: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components")['Html']>
export const LazyBody: LazyComponent<typeof import("../../../nuxt/dist/head/runtime/components")['Body']>
export const LazyNuxtIsland: LazyComponent<typeof import("../../../nuxt/dist/app/components/nuxt-island")['default']>

export const componentNames: string[]
