// // composables/useProfile.js
// export const useProfile = () => {
//   const loading = ref(true);
//   const error = ref(null);
//   const user = ref(null);

//   const getProfile = async () => {
//     try {
//       loading.value = true;
//       error.value = null;

//       await new Promise((resolve) => setTimeout(resolve, 500));

//       const mockData = await import("~/mocks/user.json");
//       const response = mockData;

//       user.value = response.user;
//       return response;
//     } catch (err) {
//       console.error("خطا در دریافت پروفایل:", err);
//       error.value = err;
//       return null;
//     } finally {
//       loading.value = false;
//     }
//   };

//   return {
//     getProfile,
//     user,
//     loading,
//     error,
//   };
// };

// composables/useProfile.js
export const useProfile = () => {
  const config = useRuntimeConfig();

  const loading = ref(false);
  const error = ref(null);
  const user = ref(null);

  const getProfile = async () => {
    try {
      loading.value = true;
      error.value = null;

      const token = process.client ? localStorage.getItem("shop_token") : null;

      if (!token) {
        throw new Error("Token not found");
      }

      const response = await $fetch(`${config.public.apiBase}/getUser`, {
        headers: {
          Authorization: `Bearer ${token}`,
        },
      });

      user.value = response.user;
      return response;
    } catch (err) {
      console.error("خطا در دریافت پروفایل:", err);
      error.value = err;
    } finally {
      loading.value = false;
    }
  };

  return {
    getProfile,
    user,
    loading,
    error,
  };
};
