import { d as useRoute, a as useRouter, c as useState, e as __nuxt_component_0$1, f as useNuxtApp, P as PageRouteSymbol, L as LayoutMetaSymbol } from './server.mjs';
import { ref, watch, mergeProps, defineComponent, unref, inject, h, Suspense, withCtx, createVNode, provide, shallowReactive, Fragment, useSSRContext } from 'vue';
import { RouterView } from 'vue-router';
import { _ as __nuxt_component_0 } from './nuxt-link-DWMZ_O5T.mjs';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderClass } from 'vue/server-renderer';
import { IconHome, IconCategory, IconShoppingCart, IconUser } from '@tabler/icons-vue';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'pinia';
import 'click-outside-vue3';

const defineRouteProvider = (name = "RouteProvider") => defineComponent({
  name,
  props: {
    route: {
      type: Object,
      required: true
    },
    vnode: Object,
    vnodeRef: Object,
    renderKey: String,
    trackRootNodes: Boolean
  },
  setup(props) {
    const previousKey = props.renderKey;
    const previousRoute = props.route;
    const route = {};
    for (const key in props.route) {
      Object.defineProperty(route, key, {
        get: () => previousKey === props.renderKey ? props.route[key] : previousRoute[key],
        enumerable: true
      });
    }
    provide(PageRouteSymbol, shallowReactive(route));
    return () => {
      if (!props.vnode) {
        return props.vnode;
      }
      return h(props.vnode, { ref: props.vnodeRef });
    };
  }
});
const RouteProvider = defineRouteProvider();
const __nuxt_component_1 = defineComponent({
  name: "NuxtPage",
  inheritAttrs: false,
  props: {
    name: {
      type: String
    },
    transition: {
      type: [Boolean, Object],
      default: void 0
    },
    keepalive: {
      type: [Boolean, Object],
      default: void 0
    },
    route: {
      type: Object
    },
    pageKey: {
      type: [Function, String],
      default: null
    }
  },
  setup(props, { attrs, slots, expose }) {
    const nuxtApp = useNuxtApp();
    const pageRef = ref();
    inject(PageRouteSymbol, null);
    expose({ pageRef });
    inject(LayoutMetaSymbol, null);
    nuxtApp.deferHydration();
    return () => {
      return h(RouterView, { name: props.name, route: props.route, ...attrs }, {
        default: (routeProps) => {
          return h(Suspense, { suspensible: true }, {
            default() {
              return h(RouteProvider, {
                vnode: slots.default ? normalizeSlot(slots.default, routeProps) : routeProps.Component,
                route: routeProps.route,
                vnodeRef: pageRef
              });
            }
          });
        }
      });
    };
  }
});
function normalizeSlot(slot, data) {
  const slotContent = slot(data);
  return slotContent.length === 1 ? h(slotContent[0]) : h(Fragment, void 0, slotContent);
}
const _sfc_main$1 = {
  __name: "Navigation",
  __ssrInlineRender: true,
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_NuxtLink = __nuxt_component_0;
      _push(`<nav${ssrRenderAttrs(_attrs)}><div class="fixed bottom-0 left-1/2 -translate-x-1/2 z-40 w-full bg-white dark:bg-gray-900 px-2 py-2 shadow-sm border-t border-gray-200/50 dark:border-gray-700"><div class="flex items-center justify-around">`);
      _push(ssrRenderComponent(_component_NuxtLink, {
        to: "/",
        class: "flex justify-center items-center"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="${ssrRenderClass([{ "bg-primary": _ctx.$route.path === "/" }, "py-2 px-4 rounded-lg"])}"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(IconHome), {
              class: ["w-6 h-6", {
                "text-white": _ctx.$route.path === "/",
                "text-gray-400": _ctx.$route.path !== "/"
              }]
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", {
                class: ["py-2 px-4 rounded-lg", { "bg-primary": _ctx.$route.path === "/" }]
              }, [
                createVNode(unref(IconHome), {
                  class: ["w-6 h-6", {
                    "text-white": _ctx.$route.path === "/",
                    "text-gray-400": _ctx.$route.path !== "/"
                  }]
                }, null, 8, ["class"])
              ], 2)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_NuxtLink, {
        to: "/categories",
        class: "flex justify-center items-center"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="${ssrRenderClass([{ "bg-primary": _ctx.$route.path === "/categories" }, "py-2 px-4 rounded-lg"])}"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(IconCategory), {
              class: ["w-6 h-6", {
                "text-white": _ctx.$route.path === "/categories",
                "text-gray-400": _ctx.$route.path !== "/categories"
              }]
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", {
                class: ["py-2 px-4 rounded-lg", { "bg-primary": _ctx.$route.path === "/categories" }]
              }, [
                createVNode(unref(IconCategory), {
                  class: ["w-6 h-6", {
                    "text-white": _ctx.$route.path === "/categories",
                    "text-gray-400": _ctx.$route.path !== "/categories"
                  }]
                }, null, 8, ["class"])
              ], 2)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_NuxtLink, {
        to: "/checkout/cart",
        class: "flex justify-center items-center"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="${ssrRenderClass([{ "bg-primary": _ctx.$route.path === "/checkout/cart" }, "py-2 px-4 rounded-lg"])}"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(IconShoppingCart), {
              class: ["w-6 h-6", {
                "text-white ": _ctx.$route.path === "/checkout/cart",
                "text-gray-400": _ctx.$route.path !== "/checkout/cart"
              }]
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", {
                class: ["py-2 px-4 rounded-lg", { "bg-primary": _ctx.$route.path === "/checkout/cart" }]
              }, [
                createVNode(unref(IconShoppingCart), {
                  class: ["w-6 h-6", {
                    "text-white ": _ctx.$route.path === "/checkout/cart",
                    "text-gray-400": _ctx.$route.path !== "/checkout/cart"
                  }]
                }, null, 8, ["class"])
              ], 2)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_NuxtLink, {
        to: "/profile",
        class: "flex justify-center items-center"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="${ssrRenderClass([{ "bg-primary": _ctx.$route.path === "/profile" }, "py-2 px-4 rounded-lg"])}"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(IconUser), {
              class: ["w-6 h-6", {
                "text-white": _ctx.$route.path === "/profile",
                "text-gray-400": _ctx.$route.path !== "/profile"
              }]
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", {
                class: ["py-2 px-4 rounded-lg", { "bg-primary": _ctx.$route.path === "/profile" }]
              }, [
                createVNode(unref(IconUser), {
                  class: ["w-6 h-6", {
                    "text-white": _ctx.$route.path === "/profile",
                    "text-gray-400": _ctx.$route.path !== "/profile"
                  }]
                }, null, 8, ["class"])
              ], 2)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></nav>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Navigation.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = {
  __name: "default",
  __ssrInlineRender: true,
  setup(__props) {
    const route = useRoute();
    useRouter();
    useState("pageTitle", () => " ");
    const backLink = ref(null);
    watch(
      () => route.meta,
      (meta) => {
        backLink.value = meta.backLink || null;
      }
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      const _component_NuxtPage = __nuxt_component_1;
      const _component_Navigation = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "pb-14 pt-19" }, _attrs))}>`);
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(ssrRenderComponent(_component_NuxtPage, null, null, _parent));
      if (unref(route).path !== "/product") {
        _push(ssrRenderComponent(_component_Navigation, null, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layouts/default.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=default-C7oBUez7.mjs.map
