import { _ as _sfc_main$1 } from './Toast-BD7HuZap.mjs';
import { _ as _sfc_main$2 } from './ErrorState-qff2oEvB.mjs';
import { t as toPersianDigits } from './toPersianDigits-DB2ZciTc.mjs';
import { ref, watchEffect, watch, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrIncludeBooleanAttr, ssrRenderAttr, ssrRenderClass } from 'vue/server-renderer';
import { p as publicAssetsURL } from '../routes/renderer.mjs';
import { IconStarFilled, IconExclamationCircleFilled, IconSend, IconMessageOff } from '@tabler/icons-vue';
import { c as useState, d as useRoute, a as useRouter, b as useRuntimeConfig } from './server.mjs';
import 'vue-bundle-renderer/runtime';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:path';
import 'node:crypto';
import 'node:url';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'pinia';
import 'vue-router';
import 'click-outside-vue3';

const _imports_0 = publicAssetsURL("/images/person.png");
const _sfc_main = {
  __name: "[productId]",
  __ssrInlineRender: true,
  setup(__props) {
    const pageTitle = useState("pageTitle");
    const route = useRoute();
    useRouter();
    const config = useRuntimeConfig();
    const showAddForm = ref(false);
    const submitting = ref(false);
    const newComment = ref({
      rate: 5,
      text: ""
    });
    const errors = ref({
      rate: "",
      text: ""
    });
    const toast = ref();
    watchEffect(() => {
      showAddForm.value = route.query.add === "true";
      if (showAddForm.value) {
        pageTitle.value = "ثبت دیدگاه";
      } else {
        pageTitle.value = "نظرات کاربران";
      }
    });
    const initialLoading = ref(true);
    const loadingMore = ref(false);
    const error = ref(false);
    const commentsData = ref(null);
    const allComments = ref([]);
    const currentPage = ref(1);
    const hasMore = ref(true);
    const expandedComments = ref({});
    ref(null);
    ref(null);
    const fetchComments = async (page = 1) => {
      try {
        if (page === 1) {
          initialLoading.value = true;
          allComments.value = [];
        } else {
          loadingMore.value = true;
        }
        error.value = false;
        const response = await $fetch(
          `${config.public.apiBase}/comments/product/${route.params.productId}?page=${page}`,
          {
            headers: {
              Authorization: `Bearer ${localStorage.getItem("shop_token")}`
            }
          }
        );
        if (response.success) {
          commentsData.value = response;
          if (page === 1) {
            allComments.value = response.comments || [];
          } else {
            allComments.value.push(...response.comments || []);
          }
          currentPage.value = response.meta.current_page;
          hasMore.value = response.meta.current_page < response.meta.last_page;
        }
      } catch (err) {
        console.error("Error fetching comments:", err);
        error.value = true;
      } finally {
        initialLoading.value = false;
        loadingMore.value = false;
      }
    };
    const isLongText = (text) => {
      const lines = text.split("\n").length;
      const charCount = text.length;
      return lines > 3 || charCount > 150;
    };
    watch(
      () => route.query.add,
      () => {
        if (route.query.add !== "true" && !commentsData.value) {
          fetchComments(1);
        }
      }
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Toast = _sfc_main$1;
      const _component_ErrorState = _sfc_main$2;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(_component_Toast, {
        ref_key: "toast",
        ref: toast
      }, null, _parent));
      if (unref(showAddForm)) {
        _push(`<div class="px-3 sm:px-4 py-4"><div class="bg-white dark:bg-gray-800 rounded-xl sm:rounded-2xl p-4 sm:p-6 shadow-sm border border-gray-100 dark:border-gray-700 space-y-5"><div class="space-y-2"><label class="text-sm font-bold text-gray-900 dark:text-white block"> امتیاز شما </label><div class="flex items-center gap-2"><!--[-->`);
        ssrRenderList(5, (star) => {
          _push(`<button type="button" class="transition-transform active:scale-110">`);
          _push(ssrRenderComponent(unref(IconStarFilled), {
            class: [
              "w-8 h-8 sm:w-9 sm:h-9",
              star <= unref(newComment).rate ? "text-yellow-400" : "text-gray-300 dark:text-gray-600"
            ]
          }, null, _parent));
          _push(`</button>`);
        });
        _push(`<!--]--></div>`);
        if (unref(errors).rate) {
          _push(`<p class="text-xs text-red-500 dark:text-red-400">${ssrInterpolate(unref(errors).rate)}</p>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="space-y-2"><label class="text-sm font-bold text-gray-900 dark:text-white block"> نظر شما </label><textarea placeholder="نظر خود را درباره این محصول بنویسید..." rows="5" class="w-full px-4 py-3 rounded-xl border-2 border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-900 text-gray-900 dark:text-white placeholder-gray-400 dark:placeholder-gray-500 focus:border-primary focus:outline-none resize-none text-sm sm:text-base">${ssrInterpolate(unref(newComment).text)}</textarea>`);
        if (unref(errors).text) {
          _push(`<p class="text-sm text-red-500 flex items-center gap-1">`);
          _push(ssrRenderComponent(unref(IconExclamationCircleFilled), { class: "w-4 h-4" }, null, _parent));
          _push(` ${ssrInterpolate(unref(errors).text)}</p>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><button${ssrIncludeBooleanAttr(unref(submitting)) ? " disabled" : ""} class="w-full py-2.5 bg-primary text-white rounded-xl font-bold text-sm sm:text-base transition-all active:scale-[0.98] disabled:opacity-50 disabled:cursor-not-allowed flex items-center justify-center gap-2">`);
        if (!unref(submitting)) {
          _push(ssrRenderComponent(unref(IconSend), { class: "w-5 h-5" }, null, _parent));
        } else {
          _push(`<div class="w-5 h-5 border-2 border-white border-t-transparent rounded-full animate-spin"></div>`);
        }
        _push(`<span>${ssrInterpolate(unref(submitting) ? "در حال ارسال..." : "ثبت نظر")}</span></button></div></div>`);
      } else {
        _push(`<div>`);
        if (unref(initialLoading)) {
          _push(`<div class="px-3 sm:px-4 py-4 space-y-3"><div class="animate-pulse space-y-3"><div class="h-24 bg-gray-200 dark:bg-gray-800 rounded-xl sm:rounded-2xl"></div><!--[-->`);
          ssrRenderList(4, (i) => {
            _push(`<div class="h-32 bg-gray-200 dark:bg-gray-800 rounded-xl sm:rounded-2xl"></div>`);
          });
          _push(`<!--]--></div></div>`);
        } else if (unref(commentsData)) {
          _push(`<div class="px-3 sm:px-4 py-4 space-y-4"><div class="bg-primary-light dark:from-primary/10 dark:to-primary/20 rounded-xl sm:rounded-2xl p-4 sm:p-5 space-y-3"><div class="flex items-center justify-between"><span class="text-sm font-bold text-gray-700 dark:text-gray-300"> میانگین امتیاز </span><div class="flex items-center gap-2"><div class="flex items-center gap-0.5"><!--[-->`);
          ssrRenderList(5, (star) => {
            _push(ssrRenderComponent(unref(IconStarFilled), {
              key: star,
              class: [
                "w-4 h-4 sm:w-5 sm:h-5",
                star <= Math.round(unref(commentsData).avg_rate) ? "text-yellow-400" : "text-gray-300 dark:text-gray-600"
              ]
            }, null, _parent));
          });
          _push(`<!--]--></div><span class="font-black text-gray-900 dark:text-white text-sm">${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(unref(commentsData).avg_rate.toFixed(1)))}</span></div></div><div class="flex items-center justify-between"><span class="text-sm font-bold text-gray-700 dark:text-gray-300"> تعداد دیدگاه‌ها </span><span class="font-black text-gray-900 dark:text-white text-sm">${ssrInterpolate(("toPersianDigits" in _ctx ? _ctx.toPersianDigits : unref(toPersianDigits))(unref(commentsData).meta.total))} دیدگاه‌ </span></div></div><div class="space-y-3"><!--[-->`);
          ssrRenderList(unref(allComments), (comment) => {
            _push(`<div class="bg-white dark:bg-gray-800 rounded-xl sm:rounded-2xl p-4 sm:p-5 shadow-sm border border-gray-100 dark:border-gray-700"><div class="flex items-center gap-3 mb-3"><div class="w-10 h-10 sm:w-12 sm:h-12 rounded-full overflow-hidden bg-primary-light flex items-center justify-center shrink-0">`);
            if (comment.user_avatar) {
              _push(`<img${ssrRenderAttr("src", comment.user_avatar)}${ssrRenderAttr("alt", comment.user_name)} class="w-full h-full object-cover">`);
            } else {
              _push(`<img${ssrRenderAttr("src", _imports_0)} alt="">`);
            }
            _push(`</div><div class="flex-1 min-w-0"><p class="font-bold text-gray-900 dark:text-white text-sm sm:text-base">${ssrInterpolate(comment.user_name)}</p><p class="text-xs text-gray-500 dark:text-gray-400">${ssrInterpolate(comment.date)}</p></div><div class="flex items-center gap-0.5 shrink-0"><!--[-->`);
            ssrRenderList(5, (star) => {
              _push(ssrRenderComponent(unref(IconStarFilled), {
                key: star,
                class: [
                  "w-4 h-4",
                  star <= comment.rate ? "text-yellow-400" : "text-gray-300 dark:text-gray-600"
                ]
              }, null, _parent));
            });
            _push(`<!--]--></div></div><div><p class="${ssrRenderClass([unref(expandedComments)[comment.id] ? "" : "line-clamp-3", "text-sm sm:text-base text-gray-700 dark:text-gray-300 leading-relaxed whitespace-pre-line"])}">${ssrInterpolate(comment.text)}</p>`);
            if (isLongText(comment.text)) {
              _push(`<button class="mt-2 text-primary font-bold text-xs sm:text-sm active:scale-95 transition-transform">${ssrInterpolate(unref(expandedComments)[comment.id] ? "نمایش کمتر" : "مشاهده بیشتر")}</button>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div></div>`);
          });
          _push(`<!--]--><div class="h-4"></div></div>`);
          if (unref(loadingMore)) {
            _push(`<div class="flex justify-center py-4"><div class="w-8 h-8 border-3 border-primary border-t-transparent rounded-full animate-spin"></div></div>`);
          } else {
            _push(`<!---->`);
          }
          if (!unref(hasMore) && unref(allComments).length > 0) {
            _push(`<div class="text-center py-4"><p class="text-sm text-gray-500 dark:text-gray-400"> همه دیدگاه‌ها نمایش داده شد </p></div>`);
          } else {
            _push(`<!---->`);
          }
          if (!unref(allComments).length && !unref(initialLoading)) {
            _push(`<div class="py-12 text-center"><div class="w-16 h-16 mx-auto mb-4 bg-gray-100 dark:bg-gray-800 rounded-full flex items-center justify-center">`);
            _push(ssrRenderComponent(unref(IconMessageOff), { class: "w-8 h-8 text-gray-400" }, null, _parent));
            _push(`</div><p class="text-gray-500 dark:text-gray-400 text-sm sm:text-base"> هنوز دیدگاهی ثبت نشده است </p></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else if (unref(error)) {
          _push(`<div class="flex h-[calc(100vh-132px)] justify-center">`);
          _push(ssrRenderComponent(_component_ErrorState, { onRetry: fetchComments }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/comments/[productId].vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=_productId_-dqX1cRIB.mjs.map
