import { _ as __nuxt_component_0 } from './CardSkeleton-DlzHsUMp.mjs';
import { _ as _sfc_main$1 } from './ProductCard-BvqNuvr3.mjs';
import { ref, computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderClass, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import { IconPackageOff } from '@tabler/icons-vue';
import { d as useRoute, c as useState } from './server.mjs';

const _sfc_main = {
  __name: "ProductsListPage",
  __ssrInlineRender: true,
  props: {
    endpoint: {
      type: String,
      required: true
    },
    pageTitle: {
      type: String,
      required: false
    }
  },
  setup(__props) {
    const props = __props;
    useRoute();
    const pageTitleState = useState("pageTitle");
    pageTitleState.value = props.pageTitle;
    const products = ref([]);
    const initialLoading = ref(true);
    const loadingMore = ref(false);
    ref(false);
    const activeFilter = ref("all");
    ref(null);
    const currentPage = ref(1);
    const lastPage = ref(1);
    const hasMore = computed(() => currentPage.value < lastPage.value);
    ref(null);
    const filters = [
      { id: "all", label: "همه محصولات" },
      { id: "highest-discount", label: "بیشترین تخفیف" },
      { id: "newest", label: "جدیدترین" },
      { id: "cheapest", label: "ارزان‌ترین" },
      { id: "expensive", label: "گران‌ترین" }
    ];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CardSkeleton = __nuxt_component_0;
      const _component_ProductCard = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "min-h-screen p-4" }, _attrs))}>`);
      if (unref(initialLoading)) {
        _push(`<div class="w-full mb-6 flex gap-3 overflow-x-auto pb-2 scrollbar-hide"><!--[-->`);
        ssrRenderList(16, (i) => {
          _push(`<div class="w-29 h-9.5 shrink-0 rounded-full bg-gray-200 dark:bg-gray-700 animate-pulse"></div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<div class="mb-6 flex gap-3 overflow-x-auto pb-2 scrollbar-hide"><!--[-->`);
        ssrRenderList(filters, (filter) => {
          _push(`<button class="${ssrRenderClass([
            "px-4 py-2 rounded-full font-medium text-sm whitespace-nowrap transition-all",
            unref(activeFilter) === filter.id ? "bg-red-600 text-white shadow-md shadow-red-600/30 border border-red-600 dark:border-red-600" : "bg-white dark:bg-gray-800 text-gray-700 dark:text-gray-300 border border-gray-200 dark:border-gray-700"
          ])}">${ssrInterpolate(filter.label)}</button>`);
        });
        _push(`<!--]--></div>`);
      }
      if (!unref(initialLoading) && unref(products).length === 0) {
        _push(`<div class="flex flex-col items-center justify-center min-h-[60vh] px-4"><div class="w-24 h-24 mb-6 rounded-full bg-gray-100 dark:bg-gray-800 flex items-center justify-center">`);
        _push(ssrRenderComponent(unref(IconPackageOff), { class: "w-12 h-12 text-gray-400 dark:text-gray-600" }, null, _parent));
        _push(`</div><h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2"> محصولی یافت نشد </h3><p class="text-gray-600 dark:text-gray-400 text-center mb-6 max-w-sm"> در حال حاضر محصولی در این بخش وجود ندارد </p></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(initialLoading)) {
        _push(`<div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-4"><!--[-->`);
        ssrRenderList(6, (i) => {
          _push(ssrRenderComponent(_component_CardSkeleton, {
            key: i,
            class: "w-full"
          }, null, _parent));
        });
        _push(`<!--]--></div>`);
      } else if (unref(products).length > 0) {
        _push(`<div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-4"><!--[-->`);
        ssrRenderList(unref(products), (product) => {
          _push(ssrRenderComponent(_component_ProductCard, {
            key: product.id,
            product,
            class: "w-full"
          }, null, _parent));
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(loadingMore)) {
        _push(`<div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-4 mt-4"><!--[-->`);
        ssrRenderList(4, (i) => {
          _push(ssrRenderComponent(_component_CardSkeleton, {
            key: i,
            class: "w-full"
          }, null, _parent));
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      if (!unref(initialLoading) && !unref(hasMore) && unref(products).length > 0) {
        _push(`<div class="text-center py-8 text-gray-500 dark:text-gray-400"> همه محصولات نمایش داده شد </div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="h-1"></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ProductsListPage.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=ProductsListPage-CQIB43-V.mjs.map
